clear all
clc
close all

%% Create Data

load AALabData
features=FeaturesAct;
Row=row;
Freq=freq;
clear row column

load AANewData
features=[features;FeaturesAct];
Row=[Row;row'];
Freq=[Freq; freq];
clear row column

load AAMTData
features=[features;FeaturesAct];
Row=[Row;row];
Freq=[Freq; freq];
clear row column

% Find Frequency of Play of Level 1 Action

N=length(Freq);
alpha=0.625;

Lev1Act=cell(1,N);
for i=1:N
    G=Row{i};
    G=G.^alpha;
    maxpay=sum(G,2);
    Lev1Act{i}=find(maxpay==max(maxpay)); %Find level 1 action(s)
end

freqlev1=zeros(1,N);
for i=1:N
    [~,b]=max(Freq(i,Lev1Act{i})); %Find the level 1 action that was played most often
    freqlev1(i)=Freq(i,Lev1Act{i}(b)+4); %Frequency with which level 1 action is played
end

B = TreeBagger(30,features,freqlev1,'OOBPrediction','On','Method','regression','MaxNumSplits',10);

% Create games
newgames=makenew(Row,200);
newrow=newgames{1};
newcolumn=newgames{2};
allvars=AAmakefeatures(newrow,newcolumn);
X=allvars{1};

m=100; %number of iterations
threshold=0.5;
for i=1:m
predictions{i}=predict(B,X);
drop=find(predictions{i}>threshold);
dropnum(i)=length(drop);

if length(drop)>0
    X(drop,:)=[];
    newrow(drop)=[];
    newcolumn(drop)=[];
    K=length(drop);
    vars=repeat(K,Row,newrow,newcolumn,X);
    newrow=vars{1};
    newcolumn=vars{2};
    X=vars{3};
end
end

savepred=predict(B,X);

%diary newgamesBag.txt

fprintf('Drop fractions')
fprintf('\n')
formatSpec = '%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f,%3.0f';
fprintf(formatSpec,dropnum);
fprintf('\n')
fprintf('\n')
    
n=length(newrow);
for i=1:n
    R=newrow{i};
    C=newcolumn{i};
    Rrisk=R.^alpha;
    
    fprintf('Payoff Matrix')
    fprintf('\n') 
    formatSpec = '%3.0f,%3.0f  %3.0f,%3.0f  %3.0f,%3.0f\n %3.0f,%3.0f  %3.0f,%3.0f  %3.0f,%3.0f\n %3.0f,%3.0f  %3.0f,%3.0f  %3.0f,%3.0f\n';
    fprintf(formatSpec,R(1,1),C(1,1),R(1,2),C(1,2),R(1,3),C(1,3),R(2,1),C(2,1),R(2,2),C(2,2),R(2,3),C(2,3),R(3,1),C(3,1),R(3,2),C(3,2),R(3,3),C(3,3));
    fprintf('\n') 
    formatSpec = '%3.0f,%3.0f,%3.0f';
    sumR=sum(R,2);
    fprintf('Row sums are ')
    fprintf(formatSpec,sumR(1),sumR(2),sumR(3));
    fprintf('\n') 
    sumRrisk=sum(Rrisk,2);
    fprintf('Row sums (with risk aversion) are ')
    fprintf(formatSpec,sumRrisk(1),sumRrisk(2),sumRrisk(3));
    fprintf('\n') 
    fprintf('Predicted Frequency of Level 1 Action is ')
    formatSpec = '%0.3f';
    fprintf(formatSpec,savepred(i));
    fprintf('\n') 
    fprintf('\n') 
end

%save newgamesBag newrow newcolumn